/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.Random;
import java.util.Set;
import technology.rocketjump.undermount.assets.FloorDictionary;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.WallTypeDictionary;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.entities.EntityStore;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;
import technology.rocketjump.undermount.mapping.OutdoorLightProcessor;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.mapping.tile.TileRoof;
import technology.rocketjump.undermount.mapping.tile.layout.WallLayout;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;

public class GameMapConverter {
    private final FloorDictionary floorDictionary;
    private final WallTypeDictionary wallTypeDictionary;
    private final GameMaterialDictionary materialDictionary;
    private final OutdoorLightProcessor outdoorLightProcessor;
    private static final int DESIRED_NUM_TILES_TO_MOUNTAIN = 12;

    @Inject
    public GameMapConverter(FloorDictionary floorDictionary, WallTypeDictionary wallTypeDictionary, GameMaterialDictionary materialDictionary, OutdoorLightProcessor outdoorLightProcessor) {
        this.floorDictionary = floorDictionary;
        this.wallTypeDictionary = wallTypeDictionary;
        this.materialDictionary = materialDictionary;
        this.outdoorLightProcessor = outdoorLightProcessor;
    }

    public void apply(GameMap generatedMap, TiledMap areaMap, long seed, EntityStore entityStore) {
        MapTile targetTile;
        int y;
        int x;
        System.out.println("Converting MapGen to game map");
        long startTime = System.currentTimeMillis();
        RandomXS128 random = new RandomXS128(seed);
        WallType roughStoneWallType = this.wallTypeDictionary.getByWallTypeName("rough_stone_wall");
        FloorType roughStoneFloorType = this.floorDictionary.getByFloorTypeName("rough_stone");
        WallType oreWallType = this.wallTypeDictionary.getByWallTypeName("basic_ore");
        WallType gemWallType = this.wallTypeDictionary.getByWallTypeName("basic_gems");
        FloorType grassFloorType = this.floorDictionary.getByFloorTypeName("grass");
        FloorType dirtFloorType = this.floorDictionary.getByFloorTypeName("dirt");
        FloorType gravelFloorType = this.floorDictionary.getByFloorTypeName("gravel");
        FloorType stoneSlabFloorType = this.floorDictionary.getByFloorTypeName("stone_slab");
        GameMaterial grassMaterial = this.materialDictionary.getByName("grass");
        GameMaterial otherRockMaterial = this.materialDictionary.getByName("rock");
        GameMaterial roadMaterial = this.materialDictionary.getByName("Slate");
        for (x = 0; x < generatedMap.getWidth(); ++x) {
            for (y = 0; y < generatedMap.getHeight(); ++y) {
                GameMapTile sourceTile = generatedMap.get(x, y);
                targetTile = areaMap.getTile(x, y);
                if (sourceTile.getTileType().equals((Object)TileType.MOUNTAIN)) {
                    targetTile.setRoof(TileRoof.UNDERGROUND);
                    GameMaterial currentMaterial = this.materialDictionary.getByName(sourceTile.getRockType().getName());
                    if (sourceTile.hasRiver()) {
                        targetTile.getFloor().setFloorType(stoneSlabFloorType);
                        targetTile.getFloor().setMaterial(roadMaterial);
                        continue;
                    }
                    if (sourceTile.getFloorType().equals((Object)technology.rocketjump.undermount.mapgen.model.FloorType.Rock)) {
                        targetTile.getFloor().setFloorType(roughStoneFloorType);
                        targetTile.getFloor().setMaterial(currentMaterial);
                        continue;
                    }
                    targetTile.setWall(new Wall(new WallLayout(0), roughStoneWallType, currentMaterial), TileRoof.UNDERGROUND);
                    if (sourceTile.getGem() != null) {
                        GemType gemType = sourceTile.getGem();
                        targetTile.getWall().changeOre(gemWallType, this.materialDictionary.getByName(gemType.getName()));
                        continue;
                    }
                    if (!sourceTile.hasOre()) continue;
                    OreType oreType = sourceTile.getOre();
                    targetTile.getWall().changeOre(oreWallType, this.materialDictionary.getByName(oreType.getOreName()));
                    continue;
                }
                targetTile.setRoof(TileRoof.OPEN);
                switch (sourceTile.getSubRegion().getSubRegionType()) {
                    case FOREST: 
                    case GRASSLAND: {
                        targetTile.getFloor().setFloorType(grassFloorType);
                        targetTile.getFloor().setMaterial(grassMaterial);
                        break;
                    }
                    case PLAINS: {
                        if (((Random)random).nextBoolean()) {
                            targetTile.getFloor().setFloorType(grassFloorType);
                            targetTile.getFloor().setMaterial(grassMaterial);
                            break;
                        }
                        targetTile.getFloor().setFloorType(dirtFloorType);
                        targetTile.getFloor().setMaterial(grassMaterial);
                        break;
                    }
                    case TUNDRA: {
                        targetTile.getFloor().setFloorType(gravelFloorType);
                        targetTile.getFloor().setMaterial(otherRockMaterial);
                    }
                }
                if (sourceTile.hasRiver()) {
                    targetTile.getFloor().setFloorType(stoneSlabFloorType);
                    targetTile.getFloor().setMaterial(roadMaterial);
                } else if (this.neighbourHasRiver(generatedMap, x, y)) {
                    targetTile.getFloor().setFloorType(dirtFloorType);
                    targetTile.getFloor().setMaterial(grassMaterial);
                }
                if (sourceTile.hasTree()) {
                    entityStore.createTree(sourceTile.getTree().getSpeciesName(), sourceTile.getPosition(), areaMap);
                    continue;
                }
                if (!sourceTile.hasShrub()) continue;
                entityStore.createShrub(sourceTile.getShrubType().getName(), sourceTile.getPosition(), areaMap);
            }
        }
        for (x = 0; x < generatedMap.getWidth() + 1; ++x) {
            for (y = 0; y < generatedMap.getHeight() + 1; ++y) {
                float heightmapValue = generatedMap.getVertexGameMap().get(x, y).getHeight();
                areaMap.getVertex(x, y).setHeightmapValue(heightmapValue);
            }
        }
        entityStore.shuffle();
        GameMapTile gameMapTile = this.pickEmbarkPoint(generatedMap);
        areaMap.setEmbarkPoint(gameMapTile.getPosition().cpy());
        for (int x2 = 0; x2 < generatedMap.getWidth(); ++x2) {
            for (int y2 = 0; y2 < generatedMap.getHeight(); ++y2) {
                targetTile = areaMap.getTile(x2, y2);
                targetTile.update(areaMap.getNeighbours(x2, y2), areaMap.getVertices(x2, y2));
                if (!targetTile.getRoof().equals((Object)TileRoof.OPEN)) continue;
                this.markAsOutside(targetTile, areaMap);
            }
        }
        System.out.println("Took " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void markAsOutside(MapTile tile, TiledMap areaMap) {
        tile.setRoof(TileRoof.OPEN);
        for (MapVertex vertex : areaMap.getVertexNeighboursOfCell(tile).values()) {
            vertex.setOutsideLightAmount(1.0f);
            this.outdoorLightProcessor.propagateLightFromMapVertex(areaMap, vertex, 1.0f);
        }
    }

    private boolean neighbourHasRiver(GameMap generatedMap, int x, int y) {
        return generatedMap.get(x - 1, y - 1) != null && generatedMap.get(x - 1, y - 1).hasRiver() || generatedMap.get(x, y - 1) != null && generatedMap.get(x, y - 1).hasRiver() || generatedMap.get(x + 1, y - 1) != null && generatedMap.get(x + 1, y - 1).hasRiver() || generatedMap.get(x - 1, y) != null && generatedMap.get(x - 1, y).hasRiver() || generatedMap.get(x + 1, y) != null && generatedMap.get(x + 1, y).hasRiver() || generatedMap.get(x - 1, y + 1) != null && generatedMap.get(x - 1, y + 1).hasRiver() || generatedMap.get(x, y + 1) != null && generatedMap.get(x, y + 1).hasRiver() || generatedMap.get(x + 1, y + 1) != null && generatedMap.get(x + 1, y + 1).hasRiver();
    }

    private GameMapTile pickEmbarkPoint(GameMap generatedMap) {
        MapRegion largestOutsideRegion = new MapRegion(TileType.OUTSIDE);
        for (MapRegion mapRegion : generatedMap.getRegions().values()) {
            if (!mapRegion.getTileType().equals((Object)TileType.OUTSIDE) || mapRegion.getNumBorderTiles() <= largestOutsideRegion.getNumBorderTiles()) continue;
            largestOutsideRegion = mapRegion;
        }
        Set<GameMapTile> regionTiles = largestOutsideRegion.getTiles();
        GameMapTile bestCandidate = regionTiles.iterator().next();
        float bestCandidateScore = 0.0f;
        for (GameMapTile regionTile : regionTiles) {
            float thisCandidateScore = this.calculateEmbarkPointScore(regionTile, largestOutsideRegion, generatedMap);
            if (!(thisCandidateScore > bestCandidateScore)) continue;
            bestCandidateScore = thisCandidateScore;
            bestCandidate = regionTile;
        }
        return bestCandidate;
    }

    private float calculateEmbarkPointScore(GameMapTile tile, MapRegion containingRegion, GameMap map) {
        int y;
        GameMapTile cursorTile;
        int x;
        float mountainNearnessScore = 0.0f;
        float surroundingSpaceScore = 0.0f;
        int numTilesNorth = 0;
        int numTilesEast = 0;
        int numTilesSouth = 0;
        int numTilesWest = 0;
        int numTilesToMountain = Integer.MAX_VALUE;
        int numTilesToEdge = Math.max(map.getWidth(), map.getHeight());
        for (x = tile.getPosition().x + 1; x < map.getHeight(); ++x) {
            cursorTile = map.get(x, tile.getPosition().y);
            if (cursorTile == null) {
                if (numTilesWest >= numTilesToEdge) break;
                numTilesToEdge = numTilesWest;
                break;
            }
            if (cursorTile.getRegion().getRegionId() == containingRegion.getRegionId()) {
                ++numTilesWest;
                continue;
            }
            if (!cursorTile.getRegion().getTileType().equals((Object)TileType.MOUNTAIN) || numTilesWest >= numTilesToMountain) break;
            numTilesToMountain = numTilesWest;
            break;
        }
        for (x = tile.getPosition().x - 1; x >= 0; --x) {
            cursorTile = map.get(x, tile.getPosition().y);
            if (cursorTile == null) {
                if (numTilesEast >= numTilesToEdge) break;
                numTilesToEdge = numTilesEast;
                break;
            }
            if (cursorTile.getRegion().getRegionId() == containingRegion.getRegionId()) {
                ++numTilesEast;
                continue;
            }
            if (!cursorTile.getRegion().getTileType().equals((Object)TileType.MOUNTAIN) || numTilesEast >= numTilesToMountain) continue;
            numTilesToMountain = numTilesEast;
        }
        for (y = tile.getPosition().y + 1; y < map.getHeight(); ++y) {
            cursorTile = map.get(tile.getPosition().x, y);
            if (cursorTile == null) {
                if (numTilesNorth >= numTilesToEdge) break;
                numTilesToEdge = numTilesNorth;
                break;
            }
            if (cursorTile.getRegion().getRegionId() == containingRegion.getRegionId()) {
                ++numTilesNorth;
                continue;
            }
            if (!cursorTile.getRegion().getTileType().equals((Object)TileType.MOUNTAIN) || numTilesNorth >= numTilesToMountain) continue;
            numTilesToMountain = numTilesNorth;
        }
        for (y = tile.getPosition().y - 1; y >= 0; --y) {
            cursorTile = map.get(tile.getPosition().x, y);
            if (cursorTile == null) {
                if (numTilesWest >= numTilesToEdge) break;
                numTilesToEdge = numTilesWest;
                break;
            }
            if (cursorTile.getRegion().getRegionId() == containingRegion.getRegionId()) {
                ++numTilesWest;
                continue;
            }
            if (!cursorTile.getRegion().getTileType().equals((Object)TileType.MOUNTAIN) || numTilesWest >= numTilesToMountain) continue;
            numTilesToMountain = numTilesWest;
        }
        mountainNearnessScore = Math.abs(12 - numTilesToMountain);
        mountainNearnessScore = Math.min(mountainNearnessScore, 12.0f);
        mountainNearnessScore = 1.0f - mountainNearnessScore / 12.0f;
        float edgeNearnessScore = numTilesToEdge / Math.max(map.getWidth(), map.getHeight());
        Vector2 mapCenter = new Vector2((float)map.getWidth() / 2.0f, (float)map.getHeight() / 2.0f);
        Vector2 tileVector = new Vector2((float)tile.getPosition().x + 0.5f, (float)tile.getPosition().y + 0.5f);
        float mapCenterScore = 1.0f - mapCenter.cpy().sub(tileVector).len() / mapCenter.len();
        surroundingSpaceScore = (float)(numTilesNorth + numTilesSouth) / (float)map.getHeight() + (float)(numTilesWest + numTilesEast) / (float)map.getWidth() / 2.0f;
        return (mountainNearnessScore + surroundingSpaceScore + edgeNearnessScore + mapCenterScore) / 4.0f;
    }
}

